/*	Renegade Scripts.dll
	SSGM scripts
	Copyright 2007 Vloktboky, Whitedragon(MDB), Mac, Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/

#ifndef GMSCRIPTS_H
#define GMSCRIPTS_H


//Fix for the double created event bug when attaching scripts in the level loaded hook.
class MDB_SSGM_Base : public ScriptImpClass {
public:
	MDB_SSGM_Base();
	void Created(GameObject *obj);
	virtual void NewCreated(GameObject *obj) = 0;
	bool WasCreated;
};

//******************************************************************************
//************************* PLAYER RELATED SCRIPTS *****************************
//******************************************************************************

//This script is attached to all players.
class MDB_SSGM_Player : public ScriptImpClass {
	void Created(GameObject *obj);
	void Destroyed(GameObject *obj);
	void Killed(GameObject *obj, GameObject *shooter);
	void Timer_Expired(GameObject *obj, int number);
	Vector3 SpawnPos;
	int AfkDetect;
	bool WasKilled;
};

//This script is attached to all players if combat refills are disabled.
class MDB_SSGM_Block_Refill : public ScriptImpClass {
	void Created(GameObject *obj);
	void Damaged(GameObject *obj, GameObject *damager, float damage);
	void Timer_Expired(GameObject *obj, int number);
	float currhealth,currshield;
	int LastDamage;
};

//Attached to all character presets in leveledit. Grants additional weapons besides their main weapon.
class M00_GrantPowerup_Created : public ScriptImpClass {
	void Created(GameObject *obj);
};

//Attached to all weapons dropped by players.
//Note to self: Needs to be replaced with DA weapon system.
class MDB_SSGM_Drop_Weapon : public ScriptImpClass {
	void Custom(GameObject *obj, int message, int param, GameObject *sender);
	void Created(GameObject *obj);
	void Timer_Expired(GameObject *obj, int number);
};

class MDB_SSGM_Spawn_Weapon : public ScriptImpClass {
	void Created(GameObject *obj);
};


//******************************************************************************
//************************* VEHICLE RELATED SCRIPTS ****************************
//******************************************************************************

//Attached to all vehicles.
class MDB_SSGM_Vehicle : public ScriptImpClass {
public:
	void Created(GameObject *obj);
	void Killed(GameObject *obj, GameObject *shooter);
	void Custom(GameObject *obj, int message, int param, GameObject *sender);
	void Damaged(GameObject *obj, GameObject *damager, float damage);
	float LastDamage;
};

//Attached to all harvesters.
class MDB_SSGM_Harvester : public MDB_SSGM_Vehicle {
	void Created(GameObject *obj);
	void Damaged(GameObject *obj, GameObject *damager, float damage);
	void Timer_Expired(GameObject *obj, int number);
	bool PlayDamage;
};

//Attached to the vehicle destruction animations.
class MDB_SSGM_Destroy_On_Create : public ScriptImpClass {
	void Created(GameObject *obj);
};

//Attached to all vehicles if damage animations are enabled.
class MDB_SSGM_Vehicle_Damage_Animation : public ScriptImpClass {
	int VehDamageTimerNew;
	void Created(GameObject *obj);
	void Destroyed(GameObject *obj);
	void Timer_Expired(GameObject *obj, int number);
	bool IsFirstShow, IsSecondShow, Sent;
	float TotalHealth, CurrentHealth;
	int Fire1ID, Fire2ID, Fire3ID, Fire4ID, Explosion1ID, Explosion2ID;
	int Size;
	bool NoExp1, NoExp2, IsStealth;
};

//Attached to all vehicle shells.
class MDB_SSGM_Vehicle_Shell : public ScriptImpClass {
	virtual void Created(GameObject* object);
	virtual void Damaged(GameObject* object, GameObject* damager, float damage);
	int ExOwner;
	float DamagerArray[128];
};

//Attached to all bound vehicles.
class MDB_SSGM_Vehicle_Owner : public ScriptImpClass {
	void Created(GameObject *obj);
	void Custom(GameObject *obj, int message, int param, GameObject *sender);
	void Killed(GameObject *obj, GameObject *shooter);
	void Destroyed(GameObject *obj);
	void Detach(GameObject *obj);
	void Timer_Expired(GameObject *obj, int number);
	void Damaged(GameObject *obj, GameObject *damager, float damage);
	int MyOwner(int Type);
	int Team,IconID,IconID2;
	bool IsLocked;
};


//******************************************************************************
//************************ BUILDING RELATED SCRIPTS ****************************
//******************************************************************************

//Attached to all buildings.
class MDB_SSGM_Building : public MDB_SSGM_Base {
	void NewCreated(GameObject *obj);
	void Killed(GameObject *obj, GameObject *shooter);
	void Damaged(GameObject *obj, GameObject *damager, float damage);
	void Timer_Expired(GameObject *obj, int number);
	bool ReportDamage;
	int LastID, B2BCount;
	bool PlayHealth, OkHealth, PlayRepair;
	bool IsAlive;
};

//Attached to all minor base defense.
class MDB_SSGM_Base_Defense : public MDB_SSGM_Base {
	void NewCreated(GameObject *obj);
	void Killed(GameObject *obj, GameObject *shooter);
	void Damaged(GameObject *obj, GameObject *damager, float damage);
	void Timer_Expired(GameObject *obj, int number);
	bool PlayDamage;
};


//******************************************************************************
//************************* BEACON RELATED SCRIPTS *****************************
//******************************************************************************

//Attached to all beacons.
class MDB_SSGM_Beacon : public ScriptImpClass {
	void Created(GameObject *obj);
	void Destroyed(GameObject *obj);
	void Killed(GameObject *obj, GameObject *shooter);
	void Damaged(GameObject *obj, GameObject *damager, float damage);
	bool IsDisarmed;
	GameObject *InvisObjCont;
};

//Workaround for timers not working on beacons
class MDB_SSGM_Beacon_CreateControl : public ScriptImpClass {
	void Created(GameObject *obj);
	void Timer_Expired(GameObject *obj, int number);
};


//******************************************************************************
//*************************** C4 RELATED SCRIPTS *******************************
//******************************************************************************

//Attached to all C4.
class MDB_SSGM_C4 : public ScriptImpClass {
	void Created(GameObject *obj);
	void Killed(GameObject * obj,GameObject * shooter);
	void Damaged(GameObject *obj, GameObject *damager, float damage);
	void Destroyed(GameObject *obj);
	bool WasDisarmed;
};

//Hack job way of detecting C4 detonations.
class MDB_SSGM_C4_Detonation : public ScriptImpClass {
	void Created(GameObject *obj);
	void Timer_Expired(GameObject *obj, int number);
};


//******************************************************************************
//************************* MISCELLANEOUS SCRIPTS ******************************
//******************************************************************************

class MDB_SSGM_Random_Weather : public MDB_SSGM_Base {
	void NewCreated(GameObject *obj);
	void Timer_Expired(GameObject *obj, int number);
	float Range, CurrentClouds, CurrentRain, CurrentLightning, CurrentSnow, CurrentAsh, CurrentWind, FogEnd;
};

class KAK_Obelisk_Powerup : public ScriptImpClass {
	void Created(GameObject *obj);
	void Custom(GameObject *obj, int message, int param, GameObject *sender);
	void Timer_Expired(GameObject *obj, int number);
	GameObject *Powerup;
	bool IsPowerup;
	int LastID, ObGlitchCount;
};

class M00_PCT_Pokable_DAK : public ScriptImpClass {
	void Damaged(GameObject *obj, GameObject *damager, float damage);
	void Killed(GameObject *obj, GameObject *shooter);
	void Poked(GameObject *obj,GameObject * poker);
	void Timer_Expired(GameObject *obj, int number);
};

class KAK_CargoPlane_Sounds : public ScriptImpClass {
	void Created(GameObject *obj);
	void Timer_Expired(GameObject *obj, int number);
	void Damaged(GameObject *obj, GameObject *damager, float damage);
};

class MDB_SSGM_Destroy_When_Object_Destroyed : public ScriptImpClass {
	void Created(GameObject *obj);
	void Timer_Expired(GameObject *obj, int number);
	int ID;
};

class MDB_SSGM_Manager : public MDB_SSGM_Base {
	void NewCreated(GameObject *obj);
	void Timer_Expired(GameObject *obj, int number);
};

class M00_Disable_Transitions : public ScriptImpClass {
	void Created(GameObject *obj);
	void Damaged(GameObject *obj, GameObject *damager, float damage);
};

#endif
